﻿/*
VERSION:	1.4

USAGE:
	#include "addMotionBlur.as"
	this.createEmptyMovieClip( "motionBlur_mc", nextDepth(this) );
	addMotionBlur( motionBlur_mc );
	
MAXIMUM USAGE:
	#include "addMotionBlur.as"
	target_mc.createEmptyMovieClip( "motionBlur_mc", nextDepth(target_mc) );
	addMotionBlur( target_mc.motionBlur_mc, this, 70, 320, 240 );
	
NOTE:
	The motion blur's movieClip MUST be inside of the source movieClip
	that is being blurred.
	
WHAT THIS IS FOR:
	Making a full-screen motion blur effect.
	
WHAT THIS DOES:
	- Displays a screenshot at reduced opacity for 1 frame,
	- Takes a picture of everything  (including the previous screenshot still being displayed),
	- updates the displayed screenshot.
	Screenshots end up getting combined as they take pictures of each other, creating a trailing effect.
	
NOTE:
	To end the motion blur effect:
	Call motionBlur() once more with values of ZERO,
	OR: remove  _root.blur_mc
*/



_global.addMotionBlur = function( _this, source_mc, blurAmount, screenWidth, screenHeight )
{
	// resolve optional parameters
	_this.source_mc = (source_mc) ? source_mc : _this._parent;
	_this.blurAmount = (blurAmount) ? blurAmount : 70;						// default:  70
	_this.screenWidth = (screenWidth) ? screenWidth : Stage.width;		// default:  Stage.width
	_this.screenHeight = (screenHeight) ? screenHeight : Stage.height;	// default:  Stage.height
	
	// set blur fade amount
	_this._alpha = _this.blurAmount;
	
	// create switch
	_this.active = true;
	
	
	
	_this.onEnterFrame = function()
	{
		if (_this.active)
		{
			// create new image
			var newBlur_pic = new flash.display.BitmapData( _this.screenWidth, _this.screenHeight, true, 0x00000000 );
			// take a snapshot
			newBlur_pic.draw(_this.source_mc);
			// display the snapshot
			_this.attachBitmap( newBlur_pic, 0, false, false );
			// replace old image
			delete _this.blur_pic;
			_this.blur_pic = newBlur_pic;
		}// if:  ON
		else
		{
			_this.blur_pic.dispose();
			
			delete _this.blur_pic;
		}// if:  OFF
	}// loop()
}// addMotionBlur()
